<?php
/**
 * @author QuanticaLabs - http://codecanyon.net/user/QuanticaLabs/portfolio?ref=QuanticaLabs
 *
 * @link			http://codecanyon.net/item/timetable-responsive-schedule-for-joomla/9749539?ref=QuanticaLabs
 * @copyright		Copyright (C) 2008 - 2014 quanticalabs.com . All rights reserved.
 * @license			GNU General Public License version 2 or later; see LICENSE under Licensing/ directory
 */
 
defined('_JEXEC') or die('Restricted access');

/**
 * Event View
 */
class TimetableViewEvent extends JViewLegacy
{
	
	protected $item;
	protected $form;
	protected $state;
	
	public function display($tpl = null)
	{
		// get the Data
		$this->state	= $this->get('State');
		$this->item		= $this->get('Item');
		$this->form		= $this->get('Form');
		
		// Check for errors.
		if (count($errors = $this->get('Errors'))) {
			JError::raiseError(500, implode('<br />', $errors));
			return false;
		}
		
		$this->addToolBar();
		$this->setDocument();
		parent::display($tpl);        
	}

	/**
	 * Setting the toolbar
	 */
	protected function addToolBar()
	{
		$input = JFactory::getApplication()->input;
		$input->set('hidemainmenu', true);
		$isNew = ($this->item->id == 0);

		JFactory::getApplication()->input->set('hidemainmenu', true);
		$isNew = ($this->item->id == 0);
		JToolbarHelper::title(JText::_('COM_TIMETABLE_MANAGER_EVENT'), 'feed newsfeeds');
		JToolbarHelper::apply('event.apply');
		JToolbarHelper::save('event.save');
		JToolbarHelper::save2new('event.save2new');
		JToolbarHelper::cancel('event.cancel');
	}
	
	protected function setDocument() 
	{
		$isNew = ($this->item->id < 1);
		$document = JFactory::getDocument();
		$document->setTitle($isNew ? JText::_('COM_TIMETABLE_EVENT_CREATING')
								   : JText::_('COM_TIMETABLE_EVENT_EDITING'));
		
		$document->addStylesheet(COM_TIMETABLE_STYLES_URL . "style.css");
		$document->addStylesheet(COM_TIMETABLE_STYLES_URL . "colorpicker.css");
		
		JHtml::_('jquery.framework');
		$document->addScript("//ajax.googleapis.com/ajax/libs/jqueryui/1.10.4/jquery-ui.min.js");
		$document->addScript(COM_TIMETABLE_SCRIPTS_URL . "ZeroClipboard.min.js");
		$document->addScript(COM_TIMETABLE_SCRIPTS_URL . "colorpicker.js");
		$document->addScript(COM_TIMETABLE_SCRIPTS_URL . "timetable_admin.js");
		$document->addScriptDeclaration('
			config = {};
			config.id = "' . $this->item->id . '";
			config.admin_url = "' . COM_TIMETABLE_ADMIN_URL . '";
			config.img_url = "' . COM_TIMETABLE_IMAGES_URL . '";
			config.js_url = "' . COM_TIMETABLE_SCRIPTS_URL . '";
		');
	}
}